Lavalite package that provides job management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `webline/job`.

    "webline/job": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Webline\Job\Providers\JobServiceProvider::class,

And also add it to alias

    'Job'  => Webline\Job\Facades\Job::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Webline\\JobTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Webline\Job\Providers\JobServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Webline\Job\Providers\JobServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Webline\Job\Providers\JobServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/job/{modulename}

**User**

    http://path-to-route-folder/user/job/{modulename}

**Public**

    http://path-to-route-folder/jobs


### API endpoints

**List**

    http://path-to-route-folder/api/user/job/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/job/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/job/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/job/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/job/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/job/{modulename}/{slug}
    METHOD: GET