# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/webline/job/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/webline/job/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Webline\\Job\\": "packages/webline/job/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Webline\Job\Providers\JobServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Job'  => Webline\Job\Facades\Job::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Webline\\JobTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Webline\Job\Providers\JobServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Webline\Job\Providers\JobServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Webline\Job\Providers\JobServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/job/{modulename}

**User**

    http://path-to-route-folder/user/job/{modulename}

**Public**

    http://path-to-route-folder/jobs


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/job/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/job/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/job/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/job/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/job/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/job/{modulename}/{slug}
    METHOD: GET