<?php

namespace Hrm\Unit;

use User;

class Unit
{
    /**
     * $unit object.
     */
    protected $unit;

    /**
     * Constructor.
     */
    public function __construct(\Hrm\Unit\Interfaces\UnitRepositoryInterface $unit)
    {
        $this->unit = $unit;
    }

    /**
     * Returns count of unit.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.unit.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->unit->pushCriteria(new \Litepie\Hrm\Repositories\Criteria\UnitUserCriteria());
        }

        $unit = $this->unit->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('unit::' . $view, compact('unit'))->render();
    }
}
