<?php

namespace Hrm\Unit\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class UnitTransformer extends TransformerAbstract
{
    public function transform(\Hrm\Unit\Models\Unit $unit)
    {
        return [
            'id'                => $unit->getRouteKey(),
            'key'               => [
                'public'    => $unit->getPublicKey(),
                'route'     => $unit->getRouteKey(),
            ], 
            'id'                => $unit->id,
            'client_id'         => $unit->client_id,
            'ref'               => $unit->ref,
            'name'              => $unit->name,
            'email'             => $unit->email,
            'phone'             => $unit->phone,
            'address'           => $unit->address,
            'address2'          => $unit->address2,
            'post_code'         => $unit->post_code,
            'user_id'           => $unit->user_id,
            'user_type'         => $unit->user_type,
            'deleted_at'        => $unit->deleted_at,
            'created_at'        => $unit->created_at,
            'updated_at'        => $unit->updated_at,
            'url'               => [
                'public'    => trans_url('unit/'.$unit->getPublicKey()),
                'user'      => guard_url('unit/unit/'.$unit->getRouteKey()),
            ], 
            'status'            => trans('app.'.$unit->status),
            'created_at'        => format_date($unit->created_at),
            'updated_at'        => format_date($unit->updated_at),
        ];
    }
}