<?php

namespace Hrm\Unit\Policies;

use Litepie\User\Contracts\UserPolicy;
use Hrm\Unit\Models\Unit;

class UnitPolicy
{

    /**
     * Determine if the given user can view the unit.
     *
     * @param UserPolicy $user
     * @param Unit $unit
     *
     * @return bool
     */
    public function view(UserPolicy $user, Unit $unit)
    {
        if ($user->canDo('unit.unit.view') && $user->isAdmin()) {
            return true;
        }

        return $unit->user_id == user_id() && $unit->user_type == user_type();
    }

    /**
     * Determine if the given user can create a unit.
     *
     * @param UserPolicy $user
     * @param Unit $unit
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('unit.unit.create');
    }

    /**
     * Determine if the given user can update the given unit.
     *
     * @param UserPolicy $user
     * @param Unit $unit
     *
     * @return bool
     */
    public function update(UserPolicy $user, Unit $unit)
    {
        if ($user->canDo('unit.unit.edit') && $user->isAdmin()) {
            return true;
        }

        return $unit->user_id == user_id() && $unit->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given unit.
     *
     * @param UserPolicy $user
     * @param Unit $unit
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Unit $unit)
    {
        return $unit->user_id == user_id() && $unit->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given unit.
     *
     * @param UserPolicy $user
     * @param Unit $unit
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Unit $unit)
    {
        if ($user->canDo('unit.unit.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given unit.
     *
     * @param UserPolicy $user
     * @param Unit $unit
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Unit $unit)
    {
        if ($user->canDo('unit.unit.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
