<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'hrm',

    /*
     * Package.
     */
    'package'   => 'unit',

    /*
     * Modules.
     */
    'modules'   => ['unit'],

    
    'unit'       => [
        'model' => [
            'model'                 => \Hrm\Unit\Models\Unit::class,
            'table'                 => 'units',
            'presenter'             => \Hrm\Unit\Repositories\Presenter\UnitPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'client_id',  'ref',  'name',  'email',  'phone',  'address',  'address2',  'post_code',  'user_id',  'user_type',  'deleted_at',  'created_at',  'updated_at'],
            'translatables'         => [],
            'upload_folder'         => 'unit/unit',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Hrm',
            'package'   => 'Unit',
            'module'    => 'Unit',
        ],

    ],
];
