Lavalite package that provides finance management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `finance/finance`.

    "finance/finance": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Finance\Finance\Providers\FinanceServiceProvider::class,

And also add it to alias

    'Finance'  => Finance\Finance\Facades\Finance::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Finance\\Finance\\Seeders\\FinanceTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Finance\Finance\Providers\FinanceServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Finance\Finance\Providers\FinanceServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Finance\Finance\Providers\FinanceServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/finance/{modulename}

**User**

    http://path-to-route-folder/user/finance/{modulename}

**Public**

    http://path-to-route-folder/finances


### API endpoints

**List**

    http://path-to-route-folder/api/user/finance/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/finance/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/finance/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/finance/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/finance/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/finance/{modulename}/{slug}
    METHOD: GET