# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/finance/finance/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Finance\\Finance\\": "packages/finance/finance/src",
            "Finance\\Finance\\Seeders\\": "packages/finance/finance/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Finance\Finance\Providers\FinanceServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Finance'  => Finance\Finance\Facades\Finance::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Finance\\Finance\\Seeders\\FinanceTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Finance\Finance\Providers\FinanceServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Finance\Finance\Providers\FinanceServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Finance\Finance\Providers\FinanceServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/finance/{modulename}

**User**

    http://path-to-route-folder/user/finance/{modulename}

**Public**

    http://path-to-route-folder/finances


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/finance/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/finance/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/finance/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/finance/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/finance/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/finance/{modulename}/{slug}
    METHOD: GET