<?php

namespace B2buy\TestPackage;

use User;

class TestPackage
{
    /**
     * $test1 object.
     */
    protected $test1;

    /**
     * Constructor.
     */
    public function __construct(\B2buy\TestPackage\Interfaces\Test1RepositoryInterface $test1)
    {
        $this->test1 = $test1;
    }

    /**
     * Returns count of test_package.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.test1.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->test1->pushCriteria(new \Litepie\B2buy\Repositories\Criteria\Test1UserCriteria());
        }

        $test1 = $this->test1->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('test_package::' . $view, compact('test1'))->render();
    }
}
