<?php

namespace B2buy\TestPackage\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class Test1Transformer extends TransformerAbstract
{
    public function transform(\B2buy\TestPackage\Models\Test1 $test1)
    {
        return [
            'id'                => $test1->getRouteKey(),
            'key'               => [
                'public'    => $test1->getPublicKey(),
                'route'     => $test1->getRouteKey(),
            ], 
            
            'url'               => [
                'public'    => trans_url('test_package/'.$test1->getPublicKey()),
                'user'      => guard_url('test_package/test1/'.$test1->getRouteKey()),
            ], 
            'status'            => trans('app.'.$test1->status),
            'created_at'        => format_date($test1->created_at),
            'updated_at'        => format_date($test1->updated_at),
        ];
    }
}