<?php

namespace B2buy\TestPackage\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BondTransformer extends TransformerAbstract
{
    public function transform(\B2buy\TestPackage\Models\Bond $bond)
    {
        return [
            'id'                => $bond->getRouteKey(),
            'key'               => [
                'public'    => $bond->getPublicKey(),
                'route'     => $bond->getRouteKey(),
            ], 
            'contract_id'       => $bond->contract_id,
            'product_id'        => $bond->product_id,
            'buyer_company_id'  => $bond->buyer_company_id,
            'supplier_company_id' => $bond->supplier_company_id,
            'custom_price'      => $bond->custom_price,
            'pricing_type'      => $bond->pricing_type,
            'contract_margin_type' => $bond->contract_margin_type,
            'slug'              => $bond->slug,
            'no_of_products'    => $bond->no_of_products,
            'item_price'        => $bond->item_price,
            'advantage_product' => $bond->advantage_product,
            'deadline'          => $bond->deadline,
            'rfq_type'          => $bond->rfq_type,
            'expiry'            => $bond->expiry,
            'custom_margin'     => $bond->custom_margin,
            'custom_cost_price' => $bond->custom_cost_price,
            'custom_blanket_margin' => $bond->custom_blanket_margin,
            'deleted_at'        => $bond->deleted_at,
            'url'               => [
                'public'    => trans_url('test_package/'.$bond->getPublicKey()),
                'user'      => guard_url('test_package/bond/'.$bond->getRouteKey()),
            ], 
            'status'            => trans('app.'.$bond->status),
            'created_at'        => format_date($bond->created_at),
            'updated_at'        => format_date($bond->updated_at),
        ];
    }
}