<?php

namespace B2buy\TestPackage\Providers;

use Illuminate\Support\ServiceProvider;

class TestPackageServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'test_package');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'test_package');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerTestPackage();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();
    }


    /**
     * Register the application bindings.
     *
     * @return void
     */
    protected function registerTestPackage()
    {
        $this->app->bind('test_package', function($app) {
            return new TestPackage($app);
        });
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->booting(function()
        {
            $loader = \Illuminate\Foundation\AliasLoader::getInstance();
            $loader->alias('TestPackage', 'Lavalite\TestPackage\Facades\TestPackage');
        });
    }

    /**
     * Register bindings for the provider.
     *
     * @return void
     */
    public function registerBindings() {
        // Bind facade
        $this->app->bind('b2buy.test_package', function ($app) {
            return $this->app->make('B2buy\TestPackage\TestPackage');
        });

        // Bind Test1 to repository
        $this->app->bind(
            'B2buy\TestPackage\Interfaces\Test1RepositoryInterface',
            \B2buy\TestPackage\Repositories\Eloquent\Test1Repository::class
        );        // Bind Bond to repository
        $this->app->bind(
            'B2buy\TestPackage\Interfaces\BondRepositoryInterface',
            \B2buy\TestPackage\Repositories\Eloquent\BondRepository::class
        );

        $this->app->register(\B2buy\TestPackage\Providers\AuthServiceProvider::class);
        
        $this->app->register(\B2buy\TestPackage\Providers\RouteServiceProvider::class);
            }

    /**
     * Merges user's and test_package's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'b2buy.test_package'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Commands\MakeTestPackage::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['b2buy.test_package'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('b2buy/test_package.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/test_package')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/test_package')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
