<?php

namespace B2buy\TestPackage\Policies;

use Litepie\User\Contracts\UserPolicy;
use B2buy\TestPackage\Models\Test1;

class Test1Policy
{

    /**
     * Determine if the given user can view the test1.
     *
     * @param UserPolicy $user
     * @param Test1 $test1
     *
     * @return bool
     */
    public function view(UserPolicy $user, Test1 $test1)
    {
        if ($user->canDo('test_package.test1.view') && $user->isAdmin()) {
            return true;
        }

        return $test1->user_id == user_id() && $test1->user_type == user_type();
    }

    /**
     * Determine if the given user can create a test1.
     *
     * @param UserPolicy $user
     * @param Test1 $test1
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('test_package.test1.create');
    }

    /**
     * Determine if the given user can update the given test1.
     *
     * @param UserPolicy $user
     * @param Test1 $test1
     *
     * @return bool
     */
    public function update(UserPolicy $user, Test1 $test1)
    {
        if ($user->canDo('test_package.test1.edit') && $user->isAdmin()) {
            return true;
        }

        return $test1->user_id == user_id() && $test1->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given test1.
     *
     * @param UserPolicy $user
     * @param Test1 $test1
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Test1 $test1)
    {
        return $test1->user_id == user_id() && $test1->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given test1.
     *
     * @param UserPolicy $user
     * @param Test1 $test1
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Test1 $test1)
    {
        if ($user->canDo('test_package.test1.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given test1.
     *
     * @param UserPolicy $user
     * @param Test1 $test1
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Test1 $test1)
    {
        if ($user->canDo('test_package.test1.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
