<?php

namespace B2buy\TestPackage\Policies;

use Litepie\User\Contracts\UserPolicy;
use B2buy\TestPackage\Models\Bond;

class BondPolicy
{

    /**
     * Determine if the given user can view the bond.
     *
     * @param UserPolicy $user
     * @param Bond $bond
     *
     * @return bool
     */
    public function view(UserPolicy $user, Bond $bond)
    {
        if ($user->canDo('test_package.bond.view') && $user->isAdmin()) {
            return true;
        }

        return $bond->user_id == user_id() && $bond->user_type == user_type();
    }

    /**
     * Determine if the given user can create a bond.
     *
     * @param UserPolicy $user
     * @param Bond $bond
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('test_package.bond.create');
    }

    /**
     * Determine if the given user can update the given bond.
     *
     * @param UserPolicy $user
     * @param Bond $bond
     *
     * @return bool
     */
    public function update(UserPolicy $user, Bond $bond)
    {
        if ($user->canDo('test_package.bond.edit') && $user->isAdmin()) {
            return true;
        }

        return $bond->user_id == user_id() && $bond->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given bond.
     *
     * @param UserPolicy $user
     * @param Bond $bond
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Bond $bond)
    {
        return $bond->user_id == user_id() && $bond->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given bond.
     *
     * @param UserPolicy $user
     * @param Bond $bond
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Bond $bond)
    {
        if ($user->canDo('test_package.bond.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given bond.
     *
     * @param UserPolicy $user
     * @param Bond $bond
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Bond $bond)
    {
        if ($user->canDo('test_package.bond.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
