<?php

namespace B2buy\TestPackage\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use B2buy\TestPackage\Http\Requests\Test1Request;
use B2buy\TestPackage\Interfaces\Test1RepositoryInterface;
use B2buy\TestPackage\Models\Test1;

/**
 * Resource controller class for test1.
 */
class Test1ResourceController extends BaseController
{

    /**
     * Initialize test1 resource controller.
     *
     * @param type Test1RepositoryInterface $test1
     *
     * @return null
     */
    public function __construct(Test1RepositoryInterface $test1)
    {
        parent::__construct();
        $this->repository = $test1;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\B2buy\TestPackage\Repositories\Criteria\Test1ResourceCriteria::class);
    }

    /**
     * Display a list of test1.
     *
     * @return Response
     */
    public function index(Test1Request $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\B2buy\TestPackage\Repositories\Presenter\Test1Presenter::class)
                ->$function();
        }

        $test1s = $this->repository->paginate();

        return $this->response->setMetaTitle(trans('test_package::test1.names'))
            ->view('test_package::test1.index', true)
            ->data(compact('test1s', 'view'))
            ->output();
    }

    /**
     * Display test1.
     *
     * @param Request $request
     * @param Model   $test1
     *
     * @return Response
     */
    public function show(Test1Request $request, Test1 $test1)
    {

        if ($test1->exists) {
            $view = 'test_package::test1.show';
        } else {
            $view = 'test_package::test1.new';
        }

        return $this->response->setMetaTitle(trans('app.view') . ' ' . trans('test_package::test1.name'))
            ->data(compact('test1'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new test1.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(Test1Request $request)
    {

        $test1 = $this->repository->newInstance([]);
        return $this->response->setMetaTitle(trans('app.new') . ' ' . trans('test_package::test1.name')) 
            ->view('test_package::test1.create', true) 
            ->data(compact('test1'))
            ->output();
    }

    /**
     * Create new test1.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(Test1Request $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $test1                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('test_package::test1.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('test_package/test1/' . $test1->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/test_package/test1'))
                ->redirect();
        }

    }

    /**
     * Show test1 for editing.
     *
     * @param Request $request
     * @param Model   $test1
     *
     * @return Response
     */
    public function edit(Test1Request $request, Test1 $test1)
    {
        return $this->response->setMetaTitle(trans('app.edit') . ' ' . trans('test_package::test1.name'))
            ->view('test_package::test1.edit', true)
            ->data(compact('test1'))
            ->output();
    }

    /**
     * Update the test1.
     *
     * @param Request $request
     * @param Model   $test1
     *
     * @return Response
     */
    public function update(Test1Request $request, Test1 $test1)
    {
        try {
            $attributes = $request->all();

            $test1->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('test_package::test1.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('test_package/test1/' . $test1->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('test_package/test1/' . $test1->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the test1.
     *
     * @param Model   $test1
     *
     * @return Response
     */
    public function destroy(Test1Request $request, Test1 $test1)
    {
        try {

            $test1->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('test_package::test1.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('test_package/test1/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('test_package/test1/' . $test1->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple test1.
     *
     * @param Model   $test1
     *
     * @return Response
     */
    public function delete(Test1Request $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('test_package::test1.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('test_package/test1'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/test_package/test1'))
                ->redirect();
        }

    }

    /**
     * Restore deleted test1s.
     *
     * @param Model   $test1
     *
     * @return Response
     */
    public function restore(Test1Request $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('test_package::test1.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/test_package/test1'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/test_package/test1/'))
                ->redirect();
        }

    }

}
