<?php

namespace B2buy\TestPackage\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use B2buy\TestPackage\Interfaces\Test1RepositoryInterface;

class Test1PublicController extends BaseController
{
    // use Test1Workflow;

    /**
     * Constructor.
     *
     * @param type \B2buy\Test1\Interfaces\Test1RepositoryInterface $test1
     *
     * @return type
     */
    public function __construct(Test1RepositoryInterface $test1)
    {
        $this->repository = $test1;
        parent::__construct();
    }

    /**
     * Show test1's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $test1s = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->setMetaTitle(trans('test_package::test1.names'))
            ->view('test_package::public.test1.index')
            ->data(compact('test1s'))
            ->output();
    }


    /**
     * Show test1.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $test1 = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->setMetaTitle($test1->name . trans('test_package::test1.name'))
            ->view('test_package::public.test1.show')
            ->data(compact('test1'))
            ->output();
    }

}
