<?php

namespace B2buy\TestPackage\Http\Controllers;

use App\Http\Controllers\APIController as BaseController;
use B2buy\TestPackage\Http\Requests\Test1Request;
use B2buy\TestPackage\Interfaces\Test1RepositoryInterface;
use B2buy\TestPackage\Models\Test1;
use B2buy\TestPackage\Forms\Test1 as Form;

/**
 * APIController  class for test1.
 */
class Test1APIController extends BaseController
{

    /**
     * Initialize test1 resource controller.
     *
     * @param type Test1RepositoryInterface $test1
     *
     * @return null
     */
    public function __construct(Test1RepositoryInterface $test1)
    {
        parent::__construct();
        $this->repository = $test1;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\B2buy\TestPackage\Repositories\Criteria\Test1ResourceCriteria::class);
    }

    /**
     * Display a list of test1.
     *
     * @return Response
     */
    public function index(Test1Request $request)
    {
        return $this->repository
            ->setPresenter(\B2buy\TestPackage\Repositories\Presenter\Test1Presenter::class)
            ->paginate();
    }

    /**
     * Display test1.
     *
     * @param Request $request
     * @param Model   $test1
     *
     * @return Response
     */
    public function show(Test1Request $request, Test1 $test1)
    {
        return $test1->setPresenter(\B2buy\TestPackage\Repositories\Presenter\Test1ListPresenter::class);
        ;
    }

    /**
     * Create new test1.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(Test1Request $request)
    {
        try {
            $data              = $request->all();
            $data['user_id']   = user_id();
            $data['user_type'] = user_type();
            $data              = $this->repository->create($data);
            $message           = trans('messages.success.created', ['Module' => trans('test_package::test1.name')]);
            $code              = 204;
            $status            = 'success';
            $url               = guard_url('test_package/test1/' . $test1->getRouteKey());
        } catch (Exception $e) {
            $message = $e->getMessage();
            $code    = 400;
            $status  = 'error';
            $url     = guard_url('test_package/test1');
        }
        return compact('data', 'message', 'code', 'status', 'url');
    }

    /**
     * Update the test1.
     *
     * @param Request $request
     * @param Model   $test1
     *
     * @return Response
     */
    public function update(Test1Request $request, Test1 $test1)
    {
        try {
            $data = $request->all();

            $test1->update($data);
            $message = trans('messages.success.updated', ['Module' => trans('test_package::test1.name')]);
            $code    = 204;
            $status  = 'success';
            $url     = guard_url('test_package/test1/' . $test1->getRouteKey());
        } catch (Exception $e) {
            $message = $e->getMessage();
            $code    = 400;
            $status  = 'error';
            $url     = guard_url('test_package/test1/' . $test1->getRouteKey());
        }
        return compact('data', 'message', 'code', 'status', 'url');
    }

    /**
     * Remove the test1.
     *
     * @param Model   $test1
     *
     * @return Response
     */
    public function destroy(Test1Request $request, Test1 $test1)
    {
        try {
            $test1->delete();
            $message = trans('messages.success.deleted', ['Module' => trans('test_package::test1.name')]);
            $code    = 202;
            $status  = 'success';
            $url     = guard_url('test_package/test1/0');
        } catch (Exception $e) {
            $message = $e->getMessage();
            $code    = 400;
            $status  = 'error';
            $url     = guard_url('test_package/test1/' . $test1->getRouteKey());
        }
        return compact('message', 'code', 'status', 'url');
    }

    /**
     * Return the form elements as json.
     *
     * @param String   $element
     *
     * @return json
     */
    public function form($element = 'fields')
    {
        $form = new Form();
        return $form->form($element, true);
    }

}
