<?php

namespace B2buy\TestPackage\Forms;

class Bond
{
    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $form;

    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $element;

    /**
     * Initialize the form.
     *
     * @return null
     */
    public function __construct()
    {
        $this->setForm();
    }

    /**
     * Return form elements.
     *
     * @return array.
     */
    public function form($element = 'fields', $grouped = true)
    {
        $item = collect($this->form->get($element));
        if ($element == 'fields' && $grouped == true) {
            return $item->groupBy(['group', 'section']);
        }
        return $item;

    }

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public function setForm()
    {
        $this->form = collect([
            'form' => [
                'store' => [],
                'update' => [],
            ],
            'groups' => [
                'main' => 'Main',
            ],
            'fields' => [
                'contract_id' => [
                    "type" => 'numeric',
                    "label" => trans('test_package::bond.label.contract_id'),
                    "placeholder" => trans('test_package::bond.placeholder.contract_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'product_id' => [
                    "type" => 'html_editor',
                    "label" => trans('test_package::bond.label.product_id'),
                    "placeholder" => trans('test_package::bond.placeholder.product_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'buyer_company_id' => [
                    "type" => 'numeric',
                    "label" => trans('test_package::bond.label.buyer_company_id'),
                    "placeholder" => trans('test_package::bond.placeholder.buyer_company_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'supplier_company_id' => [
                    "type" => 'numeric',
                    "label" => trans('test_package::bond.label.supplier_company_id'),
                    "placeholder" => trans('test_package::bond.placeholder.supplier_company_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'custom_price' => [
                    "type" => 'decimal',
                    "label" => trans('test_package::bond.label.custom_price'),
                    "placeholder" => trans('test_package::bond.placeholder.custom_price'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'pricing_type' => [
                    "type" => 'radios',
                    "label" => trans('test_package::bond.label.pricing_type'),
                    "placeholder" => trans('test_package::bond.placeholder.pricing_type'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'contract_margin_type' => [
                    "type" => 'radios',
                    "label" => trans('test_package::bond.label.contract_margin_type'),
                    "placeholder" => trans('test_package::bond.placeholder.contract_margin_type'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'no_of_products' => [
                    "type" => 'numeric',
                    "label" => trans('test_package::bond.label.no_of_products'),
                    "placeholder" => trans('test_package::bond.placeholder.no_of_products'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'item_price' => [
                    "type" => 'decimal',
                    "label" => trans('test_package::bond.label.item_price'),
                    "placeholder" => trans('test_package::bond.placeholder.item_price'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'advantage_product' => [
                    "type" => 'numeric',
                    "label" => trans('test_package::bond.label.advantage_product'),
                    "placeholder" => trans('test_package::bond.placeholder.advantage_product'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'deadline' => [
                    "type" => 'date_picker',
                    "label" => trans('test_package::bond.label.deadline'),
                    "placeholder" => trans('test_package::bond.placeholder.deadline'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'rfq_type' => [
                    "type" => 'numeric',
                    "label" => trans('test_package::bond.label.rfq_type'),
                    "placeholder" => trans('test_package::bond.placeholder.rfq_type'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'expiry' => [
                    "type" => 'date_picker',
                    "label" => trans('test_package::bond.label.expiry'),
                    "placeholder" => trans('test_package::bond.placeholder.expiry'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'custom_margin' => [
                    "type" => 'text',
                    "label" => trans('test_package::bond.label.custom_margin'),
                    "placeholder" => trans('test_package::bond.placeholder.custom_margin'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'custom_cost_price' => [
                    "type" => 'text',
                    "label" => trans('test_package::bond.label.custom_cost_price'),
                    "placeholder" => trans('test_package::bond.placeholder.custom_cost_price'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'custom_blanket_margin' => [
                    "type" => 'text',
                    "label" => trans('test_package::bond.label.custom_blanket_margin'),
                    "placeholder" => trans('test_package::bond.placeholder.custom_blanket_margin'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
            ]
        );

    }
}
