<?php

// web routes  for test1
Route::prefix('{guard}/test_package')->group(function () {
    Route::resource('test1', 'Test1ResourceController');
});

// Public routes for test1
Route::get('test_packages/', 'Test1PublicController@index');
Route::get('test_packages/{slug?}', 'Test1PublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'Test1ResourceController');
            });
            // Public routes for pages
            Route::get('test_packages/', 'Test1PublicController@index');
            Route::get('test_packages/{slug?}', 'Test1PublicController@show');
        }
    );
}

// web routes  for bond
Route::prefix('{guard}/test_package')->group(function () {
    Route::resource('bond', 'BondResourceController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'BondResourceController');
            });
            // Public routes for pages
            Route::get('test_packages/', 'BondPublicController@index');
            Route::get('test_packages/{slug?}', 'BondPublicController@show');
        }
    );
}

