<?php

// API routes  for test1
Route::prefix('{guard}/test_package')->group(function () {
    Route::get('test1/form/{element}', 'Test1APIController@form');
    Route::resource('test1', 'Test1APIController');
});

// Public routes for test1
Route::get('test_packages/', 'Test1PublicController@index');
Route::get('test_packages/{slug?}', 'Test1PublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for test_packages
            Route::prefix('{guard}/test_package')->group(function () {
                Route::get('test1/form/{element}', 'Test1APIController@form');
                Route::apiResource('test1', 'Test1APIController');
            });
            // Public routes for test_packages
            Route::get('test_package/Test1', 'Test1PublicController@getTest1');
        }
    );
}

// API routes  for bond
Route::prefix('{guard}/test_package')->group(function () {
    Route::get('bond/form/{element}', 'BondAPIController@form');
    Route::resource('bond', 'BondAPIController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for test_packages
            Route::prefix('{guard}/test_package')->group(function () {
                Route::get('bond/form/{element}', 'BondAPIController@form');
                Route::apiResource('bond', 'BondAPIController');
            });
            // Public routes for test_packages
            Route::get('test_package/Bond', 'BondPublicController@getBond');
        }
    );
}

