<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Language files for bond in test_package package
    |--------------------------------------------------------------------------
    |
    | The following language lines are  for  bond module in test_package package
    | and it is used by the template/view files in this module
    |
    */

    /**
     * Singlular and plural name of the module
     */
    'name'          => 'Bond',
    'names'         => 'Bonds',
    
    /**
     * Singlular and plural name of the module
     */
    'title'         => [
        'main'  => 'Bonds',
        'sub'   => 'Bonds',
        'list'  => 'List of bonds',
        'edit'  => 'Edit bond',
        'create'    => 'Create new bond'
    ],

    /**
     * Options for select/radio/check.
     */
    'options'       => [
            'pricing_type'        => ['Advantage','RFQ','Normal'],
            'contract_margin_type' => ['All','Individual'],
            'status'              => ['Requested','Approved','Rejected','Expired','Declined'],
    ],

    /**
     * Placeholder for inputs
     */
    'placeholder'   => [
        'id'                         => 'Please enter id',
        'contract_id'                => 'Please enter contract id',
        'product_id'                 => 'Please enter product id',
        'buyer_company_id'           => 'Please enter buyer company id',
        'supplier_company_id'        => 'Please enter supplier company id',
        'custom_price'               => 'Please enter custom price',
        'pricing_type'               => 'Please select pricing type',
        'contract_margin_type'        => 'Please select contract margin type',
        'slug'                       => 'Please enter slug',
        'no_of_products'             => 'Please enter no of products',
        'item_price'                 => 'Please enter item price',
        'status'                     => 'Please select status',
        'advantage_product'          => 'Please enter advantage product',
        'deadline'                   => 'Please select deadline',
        'rfq_type'                   => 'Please enter rfq type',
        'expiry'                     => 'Please select expiry',
        'custom_margin'              => 'Please enter custom margin',
        'custom_cost_price'          => 'Please enter custom cost price',
        'custom_blanket_margin'        => 'Please enter custom blanket margin',
        'deleted_at'                 => 'Please select deleted at',
        'created_at'                 => 'Please select created at',
        'updated_at'                 => 'Please select updated at',
    ],

    /**
     * Labels for inputs.
     */
    'label'         => [
        'id'                         => 'Id',
        'contract_id'                => 'Contract id',
        'product_id'                 => 'Product id',
        'buyer_company_id'           => 'Buyer company id',
        'supplier_company_id'        => 'Supplier company id',
        'custom_price'               => 'Custom price',
        'pricing_type'               => 'Pricing type',
        'contract_margin_type'        => 'Contract margin type',
        'slug'                       => 'Slug',
        'no_of_products'             => 'No of products',
        'item_price'                 => 'Item price',
        'status'                     => 'Status',
        'advantage_product'          => 'Advantage product',
        'deadline'                   => 'Deadline',
        'rfq_type'                   => 'Rfq type',
        'expiry'                     => 'Expiry',
        'custom_margin'              => 'Custom margin',
        'custom_cost_price'          => 'Custom cost price',
        'custom_blanket_margin'        => 'Custom blanket margin',
        'deleted_at'                 => 'Deleted at',
        'created_at'                 => 'Created at',
        'updated_at'                 => 'Updated at',
    ],

    /**
     * Columns array for show hide checkbox.
     */
    'cloumns'         => [
        'contract_id'                => ['name' => 'Contract id', 'data-column' => 1, 'checked'],
        'buyer_company_id'           => ['name' => 'Buyer company id', 'data-column' => 2, 'checked'],
        'supplier_company_id'        => ['name' => 'Supplier company id', 'data-column' => 3, 'checked'],
        'custom_price'               => ['name' => 'Custom price', 'data-column' => 4, 'checked'],
        'pricing_type'               => ['name' => 'Pricing type', 'data-column' => 5, 'checked'],
        'contract_margin_type'        => ['name' => 'Contract margin type', 'data-column' => 6, 'checked'],
        'no_of_products'             => ['name' => 'No of products', 'data-column' => 7, 'checked'],
        'item_price'                 => ['name' => 'Item price', 'data-column' => 8, 'checked'],
        'advantage_product'          => ['name' => 'Advantage product', 'data-column' => 9, 'checked'],
        'deadline'                   => ['name' => 'Deadline', 'data-column' => 10, 'checked'],
        'rfq_type'                   => ['name' => 'Rfq type', 'data-column' => 11, 'checked'],
        'expiry'                     => ['name' => 'Expiry', 'data-column' => 12, 'checked'],
        'custom_margin'              => ['name' => 'Custom margin', 'data-column' => 13, 'checked'],
        'custom_cost_price'          => ['name' => 'Custom cost price', 'data-column' => 14, 'checked'],
        'custom_blanket_margin'        => ['name' => 'Custom blanket margin', 'data-column' => 15, 'checked'],
    ],

    /**
     * Tab labels
     */
    'tab'           => [
        'name'  => 'Bonds',
    ],

    /**
     * Texts  for the module
     */
    'text'          => [
        'preview' => 'Click on the below list for preview',
    ],
];
