Lavalite package that provides test_package management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `b2buy/test_package`.

    "b2buy/test_package": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    B2buy\TestPackage\Providers\TestPackageServiceProvider::class,

And also add it to alias

    'TestPackage'  => B2buy\TestPackage\Facades\TestPackage::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=B2buy\\TestPackageTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="B2buy\TestPackage\Providers\TestPackageServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="B2buy\TestPackage\Providers\TestPackageServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="B2buy\TestPackage\Providers\TestPackageServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/test_package/{modulename}

**User**

    http://path-to-route-folder/user/test_package/{modulename}

**Public**

    http://path-to-route-folder/test_packages


### API endpoints

**List**

    http://path-to-route-folder/api/user/test_package/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/test_package/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/test_package/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/test_package/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/test_package/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/test_package/{modulename}/{slug}
    METHOD: GET