# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/b2buy/test_package/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/b2buy/test_package/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "B2buy\\TestPackage\\": "packages/b2buy/test_package/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        B2buy\TestPackage\Providers\TestPackageServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'TestPackage'  => B2buy\TestPackage\Facades\TestPackage::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=B2buy\\TestPackageTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="B2buy\TestPackage\Providers\TestPackageServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="B2buy\TestPackage\Providers\TestPackageServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="B2buy\TestPackage\Providers\TestPackageServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/test_package/{modulename}

**User**

    http://path-to-route-folder/user/test_package/{modulename}

**Public**

    http://path-to-route-folder/test_packages


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/test_package/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/test_package/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/test_package/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/test_package/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/test_package/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/test_package/{modulename}/{slug}
    METHOD: GET