<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'b2buy',

    /*
     * Package.
     */
    'package'   => 'test_package',

    /*
     * Modules.
     */
    'modules'   => ['test1', 'bond'],

    'test1'       => [
        'model' => [
            'model'                 => \B2buy\TestPackage\Models\Test1::class,
            'table'                 => 'test1s',
            'presenter'             => \B2buy\TestPackage\Repositories\Presenter\Test1Presenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => [],
            'translatables'         => [],
            'upload_folder'         => 'test_package/test1',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'B2buy',
            'package'   => 'TestPackage',
            'module'    => 'Test1',
        ],

    ],
    'bond'       => [
        'model' => [
            'model'                 => \B2buy\TestPackage\Models\Bond::class,
            'table'                 => 'bonds',
            'presenter'             => \B2buy\TestPackage\Repositories\Presenter\BondPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'contract_id',  'product_id',  'buyer_company_id',  'supplier_company_id',  'custom_price',  'pricing_type',  'contract_margin_type',  'slug',  'no_of_products',  'item_price',  'status',  'advantage_product',  'deadline',  'rfq_type',  'expiry',  'custom_margin',  'custom_cost_price',  'custom_blanket_margin',  'deleted_at',  'created_at',  'updated_at'],
            'translatables'         => [],
            'upload_folder'         => 'test_package/bond',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'B2buy',
            'package'   => 'TestPackage',
            'module'    => 'Bond',
        ],

    ],
];
