Lavalite package that provides frontier_airlines_berlin_office management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `travel/frontier_airlines_berlin_office`.

    "travel/frontier_airlines_berlin_office": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Travel\FrontierAirlinesBerlinOffice\Providers\FrontierAirlinesBerlinOfficeServiceProvider::class,

And also add it to alias

    'FrontierAirlinesBerlinOffice'  => Travel\FrontierAirlinesBerlinOffice\Facades\FrontierAirlinesBerlinOffice::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Travel\\FrontierAirlinesBerlinOffice\\Seeders\\FrontierAirlinesBerlinOfficeTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Travel\FrontierAirlinesBerlinOffice\Providers\FrontierAirlinesBerlinOfficeServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Travel\FrontierAirlinesBerlinOffice\Providers\FrontierAirlinesBerlinOfficeServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Travel\FrontierAirlinesBerlinOffice\Providers\FrontierAirlinesBerlinOfficeServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/frontier_airlines_berlin_office/{modulename}

**User**

    http://path-to-route-folder/user/frontier_airlines_berlin_office/{modulename}

**Public**

    http://path-to-route-folder/frontier_airlines_berlin_offices


### API endpoints

**List**

    http://path-to-route-folder/api/user/frontier_airlines_berlin_office/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/frontier_airlines_berlin_office/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/frontier_airlines_berlin_office/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/frontier_airlines_berlin_office/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/frontier_airlines_berlin_office/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/frontier_airlines_berlin_office/{modulename}/{slug}
    METHOD: GET