# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/travel/frontier_airlines_berlin_office/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Travel\\FrontierAirlinesBerlinOffice\\": "packages/travel/frontier_airlines_berlin_office/src",
            "Travel\\FrontierAirlinesBerlinOffice\\Seeders\\": "packages/travel/frontier_airlines_berlin_office/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Travel\FrontierAirlinesBerlinOffice\Providers\FrontierAirlinesBerlinOfficeServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'FrontierAirlinesBerlinOffice'  => Travel\FrontierAirlinesBerlinOffice\Facades\FrontierAirlinesBerlinOffice::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Travel\\FrontierAirlinesBerlinOffice\\Seeders\\FrontierAirlinesBerlinOfficeTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Travel\FrontierAirlinesBerlinOffice\Providers\FrontierAirlinesBerlinOfficeServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Travel\FrontierAirlinesBerlinOffice\Providers\FrontierAirlinesBerlinOfficeServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Travel\FrontierAirlinesBerlinOffice\Providers\FrontierAirlinesBerlinOfficeServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/frontier_airlines_berlin_office/{modulename}

**User**

    http://path-to-route-folder/user/frontier_airlines_berlin_office/{modulename}

**Public**

    http://path-to-route-folder/frontier_airlines_berlin_offices


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/frontier_airlines_berlin_office/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/frontier_airlines_berlin_office/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/frontier_airlines_berlin_office/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/frontier_airlines_berlin_office/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/frontier_airlines_berlin_office/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/frontier_airlines_berlin_office/{modulename}/{slug}
    METHOD: GET