<?php

namespace Ebuy\Question\Repositories\Eloquent;

use Ebuy\Question\Interfaces\QuestionRepositoryInterface;
use Litepie\Repository\BaseRepository;
use Ebuy\Question\Repositories\Eloquent\Presenters\QuestionItemPresenter;


class QuestionRepository extends BaseRepository implements QuestionRepositoryInterface
{

    public function boot()
    {
        $this->fieldSearchable = config('ebuy.question.question.model.search');
    }

    /**
     * Specify Model class name.
     *
     * @return string
     */
    public function model()
    {
        return config('ebuy.question.question.model.model');
    }

    /**
     * Returns the default presenter if none is availabale.
     *
     * @return void
     */
    public function presenter()
    {
        return QuestionItemPresenter::class;
    }
}
