<?php

namespace Ebuy\Question\Repositories\Eloquent\Presenters;

use Litepie\Repository\Presenter\Presenter;

class QuestionItemPresenter extends Presenter
{

    public function itemLink()
    {
        return guard_url('question/question') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray()
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'product_id' => $this->product_id,
            'question' => $this->question,
            'answer' => $this->answer,
            'user_id' => $this->user_id,
            'answered_user_id' => $this->answered_user_id,
            'user_type' => $this->user_type,
            'slug' => $this->slug,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }
}
