<?php

namespace Ebuy\Question\Repositories\Eloquent;

use Ebuy\Question\Interfaces\FaqRepositoryInterface;
use Litepie\Repository\BaseRepository;
use Ebuy\Question\Repositories\Eloquent\Presenters\FaqItemPresenter;


class FaqRepository extends BaseRepository implements FaqRepositoryInterface
{

    public function boot()
    {
        $this->fieldSearchable = config('ebuy.question.faq.model.search');
    }

    /**
     * Specify Model class name.
     *
     * @return string
     */
    public function model()
    {
        return config('ebuy.question.faq.model.model');
    }

    /**
     * Returns the default presenter if none is availabale.
     *
     * @return void
     */
    public function presenter()
    {
        return FaqItemPresenter::class;
    }
}
