<?php

namespace Ebuy\Question\Providers;

use Illuminate\Support\ServiceProvider;
use Ebuy\Question\Question;

class QuestionServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'question');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'question');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();

        $this->app->register(\Ebuy\Question\Providers\AuthServiceProvider::class);
        $this->app->register(\Ebuy\Question\Providers\RouteServiceProvider::class);
        // $this->app->register(\Ebuy\Question\Providers\EventServiceProvider::class);
        // $this->app->register(\Ebuy\Question\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('ebuy.question', function($app)
        {
            return $this->app->make(Question::class);
        });
    }

    /**
     * Register the bindings for the service provider.
     *
     * @return void
     */
    public function registerBindings() {
        // Bind Question to repository
        $this->app->bind(
            'Ebuy\Question\Interfaces\QuestionRepositoryInterface',
            \Ebuy\Question\Repositories\Eloquent\QuestionRepository::class
        );        // Bind Faq to repository
        $this->app->bind(
            'Ebuy\Question\Interfaces\FaqRepositoryInterface',
            \Ebuy\Question\Repositories\Eloquent\FaqRepository::class
        );
    }


    /**
     * Merges user's and question's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'ebuy.question'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Ebuy\Question\Commands\Question::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['ebuy.question'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('ebuy/question.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/question')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/question')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
