<?php

namespace Ebuy\Question\Providers;

use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the package.
     *
     * @var array
     */
    protected $policies = [
        // Bind Question policy
        \Ebuy\Question\Repositories\Eloquent\QuestionRepository::class 
        => \Ebuy\Question\Policies\QuestionPolicy::class,// Bind Faq policy
        \Ebuy\Question\Repositories\Eloquent\FaqRepository::class 
        => \Ebuy\Question\Policies\FaqPolicy::class,
    ];

    /**
     * Register any package authentication / authorization services.
     *
     * @param \Illuminate\Contracts\Auth\Access\Gate $gate
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        parent::registerPolicies($gate);
    }
}
