<?php

namespace Ebuy\Question\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Ebuy\Question\Models\Question;

class QuestionPolicy
{

    /**
     * Determine if the given user can view the question.
     *
     * @param UserPolicyInterface $authUser
     * @param Question $question
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Question $question)
    {
        if ($authUser->canDo('question.question.view') && $authUser->isAdmin()) {
            return true;
        }

        return $question->user_id == user_id() && $question->user_type == user_type();
    }

    /**
     * Determine if the given user can create a question.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('question.question.create');
    }

    /**
     * Determine if the given user can update the given question.
     *
     * @param UserPolicyInterface $authUser
     * @param Question $question
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Question $question)
    {
        if ($authUser->canDo('question.question.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $question->user_id == user_id() && $question->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given question.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Question $question)
    {
        return $question->user_id == user_id() && $question->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given question.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Question $question)
    {
        if ($authUser->canDo('question.question.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given question.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Question $question)
    {
        if ($authUser->canDo('question.question.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
