<?php

namespace Ebuy\Question\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Ebuy\Question\Models\Faq;

class FaqPolicy
{

    /**
     * Determine if the given user can view the faq.
     *
     * @param UserPolicyInterface $authUser
     * @param Faq $faq
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Faq $faq)
    {
        if ($authUser->canDo('question.faq.view') && $authUser->isAdmin()) {
            return true;
        }

        return $faq->user_id == user_id() && $faq->user_type == user_type();
    }

    /**
     * Determine if the given user can create a faq.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('question.faq.create');
    }

    /**
     * Determine if the given user can update the given faq.
     *
     * @param UserPolicyInterface $authUser
     * @param Faq $faq
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Faq $faq)
    {
        if ($authUser->canDo('question.faq.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $faq->user_id == user_id() && $faq->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given faq.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Faq $faq)
    {
        return $faq->user_id == user_id() && $faq->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given faq.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Faq $faq)
    {
        if ($authUser->canDo('question.faq.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given faq.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Faq $faq)
    {
        if ($authUser->canDo('question.faq.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
