<?php

namespace Ebuy\Question\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Repository\Filter\RequestFilter;

use Ebuy\Question\Interfaces\QuestionRepositoryInterface;
use Ebuy\Question\Repositories\Eloquent\Filters\QuestionPublicFilter;
use Ebuy\Question\Repositories\Eloquent\Presenters\QuestionListPresenter;

class QuestionPublicController extends BaseController
{

    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct(
        QuestionRepositoryInterface $question
    ) {
        parent::__construct();
        $this->modules = $this->modules(config('ebuy.question.modules'), 'question', guard_url('question'));
        $this->repository = $question;
    }

    /**
     * Show question's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $data = $this->repository
            ->pushFilter(RequestFilter::class)
            ->pushFilter(QuestionPublicFilter::class)
            ->setPresenter(QuestionListPresenter::class)
            ->select('questions.*')
            ->paginate($pageLimit)
            ->withQueryString()
            ->toArray();

        extract($data);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('question::question.names'))
            ->view('question::public.question.index')
            ->data(compact('data', 'meta', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show question.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $data = $this->repository
            ->findBySlug($slug)
            ->toArray();

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('question::question.name'))
            ->view('question::public.question.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
