<?php

namespace Ebuy\Question\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Repository\Filter\RequestFilter;

use Ebuy\Question\Interfaces\FaqRepositoryInterface;
use Ebuy\Question\Repositories\Eloquent\Filters\FaqPublicFilter;
use Ebuy\Question\Repositories\Eloquent\Presenters\FaqListPresenter;

class FaqPublicController extends BaseController
{

    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct(
        FaqRepositoryInterface $faq
    ) {
        parent::__construct();
        $this->modules = $this->modules(config('ebuy.question.modules'), 'faq', guard_url('faq'));
        $this->repository = $faq;
    }

    /**
     * Show faq's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $data = $this->repository
            ->pushFilter(RequestFilter::class)
            ->pushFilter(FaqPublicFilter::class)
            ->setPresenter(FaqListPresenter::class)
            ->select('faqs.*')
            ->paginate($pageLimit)
            ->withQueryString()
            ->toArray();

        extract($data);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('question::faq.names'))
            ->view('question::public.faq.index')
            ->data(compact('data', 'meta', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show faq.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $data = $this->repository
            ->findBySlug($slug)
            ->toArray();

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('question::faq.name'))
            ->view('question::public.faq.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
