<?php

namespace Ebuy\Question\Forms;

use Litepie\Form\FormInterpreter;

class Question extends FormInterpreter
{

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public static function setAttributes()
    {

        self::$urls = [
            'new' => [
                'url' => guard_url('question/question/new'),
                'method' => 'GET',
            ],
            'create' => [
                'url' => guard_url('question/question/create'),
                'method' => 'GET',
            ],
            'store' => [
                'url' => guard_url('question/question'),
                'method' => 'POST',
            ],
            'update' => [
                'url' => guard_url('question/question'),
                'method' => 'PUT',
            ],
            'list' => [
                'url' => guard_url('question/question'),
                'method' => 'GET',
            ],
            'delete' => [
                'url' => guard_url('question/question'),
                'method' => 'DELETE',
            ],
        ];
        self::$search = [
            'name' => [
                "type" => 'text',
                "label" => trans('question::question.label.name'),
                "placeholder" => trans('question::question.placeholder.name'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "4",
                "roles" => [],
            ]
        ];
        self::$orderBy = [
            'created_at' => trans('question::question.label.created_at'),
            'name' => trans('question::question.label.name'),
            'status' => trans('question::question.label.status'),
        ];
        self::$groups = [
            'main' => trans('question::question.groups.main'),
            'details' => trans('question::question.groups.details'),
            'images' => trans('question::question.groups.images'),
            'settings' => trans('question::question.groups.settings'),
        ];
        self::$list = [
            [
                'key' => "ref",
                'label' => trans('question::question.label.ref'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "id",
                'label' => trans('question::question.label.id'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "name",
                'label' => trans('question::question.label.name'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "status",
                'label' => trans('question::question.label.status'),
                'sortable' => 'true',
                'roles' => [],
            ],
        ];
        self::$fields = [
                'product_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('question::question.label.product_id'),
                "placeholder" => trans('question::question.placeholder.product_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'question' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('question::question.label.question'),
                "placeholder" => trans('question::question.placeholder.question'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'answer' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('question::question.label.answer'),
                "placeholder" => trans('question::question.placeholder.answer'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'answered_user_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('question::question.label.answered_user_id'),
                "placeholder" => trans('question::question.placeholder.answered_user_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ];

        return new static();
    }
}
