<?php

// API routes  for question.

// Guard routes for question
Route::prefix('{guard}/question')->group(function () {
    Route::resource('question', 'QuestionResourceController');
});

// Guard routes for faq
Route::prefix('{guard}/question')->group(function () {
    Route::resource('faq', 'FaqResourceController');
});



// Public routes for question
Route::get('questions/', 'QuestionPublicController@index');
Route::get('question/{slug?}', 'QuestionPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for question
            Route::prefix('{guard}/question')->group(function () {
                Route::resource('question', 'QuestionResourceController');
            });
            
            // Guard routes for faq
            Route::prefix('{guard}/question')->group(function () {
                Route::resource('faq', 'FaqResourceController');
            });
            
            

            // Public routes for question
            Route::get('questions/', 'QuestionPublicController@index');
            Route::get('question/{slug?}', 'QuestionPublicController@show');
        }
    );
}