Lavalite package that provides question management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `ebuy/question`.

    "ebuy/question": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Ebuy\Question\Providers\QuestionServiceProvider::class,

And also add it to alias

    'Question'  => Ebuy\Question\Facades\Question::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Ebuy\\Question\\Seeds\\QuestionTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Ebuy\Question\Providers\QuestionServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Ebuy\Question\Providers\QuestionServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Ebuy\Question\Providers\QuestionServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/question/{modulename}

**User**

    http://path-to-route-folder/user/question/{modulename}

**Public**

    http://path-to-route-folder/questions


### API endpoints

**List**

    http://path-to-route-folder/api/user/question/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/question/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/question/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/question/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/question/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/question/{modulename}/{slug}
    METHOD: GET