# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/ebuy/question/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/ebuy/question/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Ebuy\\Question\\": "packages/ebuy/question/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Ebuy\Question\Providers\QuestionServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Question'  => Ebuy\Question\Facades\Question::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Ebuy\\QuestionTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Ebuy\Question\Providers\QuestionServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Ebuy\Question\Providers\QuestionServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Ebuy\Question\Providers\QuestionServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/question/{modulename}

**User**

    http://path-to-route-folder/user/question/{modulename}

**Public**

    http://path-to-route-folder/questions


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/question/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/question/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/question/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/question/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/question/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/question/{modulename}/{slug}
    METHOD: GET