<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: questions
         */
        Schema::create('questions', function ($table) {
            $table->increments('id');
            $table->integer('product_id')->nullable();
            $table->text('question')->nullable();
            $table->text('answer')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('answered_user_id')->nullable();
            $table->string('user_type', 255)->nullable();
            $table->string('slug', 255)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('questions');
    }
}
