<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateFaqsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: faqs
         */
        Schema::create('faqs', function ($table) {
            $table->increments('id');
            $table->string('category', 255)->nullable();
            $table->text('question')->nullable();
            $table->text('answer')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('answered_user_id')->nullable();
            $table->string('user_type', 255)->nullable();
            $table->string('slug', 255)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('faqs');
    }
}
