<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'ebuy',

    /*
     * Package.
     */
    'package'   => 'question',

    /*
     * Modules.
     */
    'modules'   => ['question', 'faq'],

    'question'       => [
        'model' => [
            'model' => \Ebuy\Question\Models\Question::class,
            'repository' => \Ebuy\Question\Repositories\Eloquent\QuestionRepository::class,
            'table' => 'questions',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'createdat', 'updated_at'],
            'appends' => [],
            'fillable' => ['id',  'product_id',  'question',  'answer',  'user_id',  'answered_user_id',  'user_type',  'slug',  'created_at',  'updated_at',  'deleted_at'],
            'translatables' => [],
            'upload_folder' => 'question/question',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider' => 'Ebuy',
            'package' => 'Question',
            'module' => 'Question',
        ],
    ],
    'faq'       => [
        'model' => [
            'model' => \Ebuy\Question\Models\Faq::class,
            'repository' => \Ebuy\Question\Repositories\Eloquent\FaqRepository::class,
            'table' => 'faqs',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'createdat', 'updated_at'],
            'appends' => [],
            'fillable' => ['id',  'category',  'question',  'answer',  'user_id',  'answered_user_id',  'user_type',  'slug',  'created_at',  'updated_at',  'deleted_at'],
            'translatables' => [],
            'upload_folder' => 'question/faq',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider' => 'Ebuy',
            'package' => 'Question',
            'module' => 'Faq',
        ],
    ],
];
