<?php

namespace Order\Eee\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Order\Eee\Models\Product;

class ProductPolicy
{

    /**
     * Determine if the given user can view the product.
     *
     * @param UserPolicyInterface $authUser
     * @param Product $product
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Product $product)
    {
        if ($authUser->canDo('eee.product.view') && $authUser->isAdmin()) {
            return true;
        }

        return $product->user_id == user_id() && $product->user_type == user_type();
    }

    /**
     * Determine if the given user can create a product.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('eee.product.create');
    }

    /**
     * Determine if the given user can update the given product.
     *
     * @param UserPolicyInterface $authUser
     * @param Product $product
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Product $product)
    {
        if ($authUser->canDo('eee.product.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $product->user_id == user_id() && $product->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given product.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Product $product)
    {
        return $product->user_id == user_id() && $product->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given product.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Product $product)
    {
        if ($authUser->canDo('eee.product.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given product.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Product $product)
    {
        if ($authUser->canDo('eee.product.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
