<?php

namespace Order\Eee\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Order\Eee\Models\OrderProductRelation;

class OrderProductRelationPolicy
{

    /**
     * Determine if the given user can view the order_product_relation.
     *
     * @param UserPolicyInterface $authUser
     * @param OrderProductRelation $order_product_relation
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, OrderProductRelation $order_product_relation)
    {
        if ($authUser->canDo('eee.order_product_relation.view') && $authUser->isAdmin()) {
            return true;
        }

        return $order_product_relation->user_id == user_id() && $order_product_relation->user_type == user_type();
    }

    /**
     * Determine if the given user can create a order_product_relation.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('eee.order_product_relation.create');
    }

    /**
     * Determine if the given user can update the given order_product_relation.
     *
     * @param UserPolicyInterface $authUser
     * @param OrderProductRelation $order_product_relation
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, OrderProductRelation $order_product_relation)
    {
        if ($authUser->canDo('eee.order_product_relation.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $order_product_relation->user_id == user_id() && $order_product_relation->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given order_product_relation.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, OrderProductRelation $order_product_relation)
    {
        return $order_product_relation->user_id == user_id() && $order_product_relation->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given order_product_relation.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, OrderProductRelation $order_product_relation)
    {
        if ($authUser->canDo('eee.order_product_relation.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given order_product_relation.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, OrderProductRelation $order_product_relation)
    {
        if ($authUser->canDo('eee.order_product_relation.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
