<?php

namespace Order\Eee\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SubscriptionResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('eee/subscription') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'company_id' => $this->company_id,
            'seller_company_id' => $this->seller_company_id,
            'user_id' => $this->user_id,
            'seller_id' => $this->seller_id,
            'order_id' => $this->order_id,
            'cart_id' => $this->cart_id,
            'address_id' => $this->address_id,
            'status' => $this->status,
            'delivery_type' => $this->delivery_type,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }
}
