<?php

namespace Order\Eee\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('eee/product') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'company_id' => $this->company_id,
            'seller_company_id' => $this->seller_company_id,
            'product_id' => $this->product_id,
            'subscription_id' => $this->subscription_id,
            'quantity' => $this->quantity,
            'repeat_interval' => $this->repeat_interval,
            'scheduler_id' => $this->scheduler_id,
            'notification_schedule_id' => $this->notification_schedule_id,
            'start_date' => $this->start_date,
            'end_date' => $this->end_date,
            'delivey_date' => $this->delivey_date,
            'skiped_date' => $this->skiped_date,
            'notification_date' => $this->notification_date,
            'status' => $this->status,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }
}
