Lavalite package that provides eee management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `order/eee`.

    "order/eee": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Order\Eee\Providers\EeeServiceProvider::class,

And also add it to alias

    'Eee'  => Order\Eee\Facades\Eee::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Order\\Eee\\Seeders\\EeeTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Order\Eee\Providers\EeeServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Order\Eee\Providers\EeeServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Order\Eee\Providers\EeeServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/eee/{modulename}

**User**

    http://path-to-route-folder/user/eee/{modulename}

**Public**

    http://path-to-route-folder/eees


### API endpoints

**List**

    http://path-to-route-folder/api/user/eee/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/eee/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/eee/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/eee/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/eee/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/eee/{modulename}/{slug}
    METHOD: GET