<?php

namespace Order\Eee\Seeders;

use DB;
use Illuminate\Database\Seeder;

class SubscriptionTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('subscriptions')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'eee.subscription.view',
                'name'      => 'View Subscription',
            ],
            [
                'slug'      => 'eee.subscription.create',
                'name'      => 'Create Subscription',
            ],
            [
                'slug'      => 'eee.subscription.edit',
                'name'      => 'Update Subscription',
            ],
            [
                'slug'      => 'eee.subscription.delete',
                'name'      => 'Delete Subscription',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/eee/subscription',
                'name'        => 'Subscription',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/eee/subscription',
                'name'        => 'Subscription',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'subscription',
                'name'        => 'Subscription',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Eee',
                'module'    => 'Subscription',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'eee.subscription.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
