<?php

namespace Order\Eee\Seeders;

use DB;
use Illuminate\Database\Seeder;

class OrderTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('orders')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'eee.order.view',
                'name'      => 'View Order',
            ],
            [
                'slug'      => 'eee.order.create',
                'name'      => 'Create Order',
            ],
            [
                'slug'      => 'eee.order.edit',
                'name'      => 'Update Order',
            ],
            [
                'slug'      => 'eee.order.delete',
                'name'      => 'Delete Order',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/eee/order',
                'name'        => 'Order',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/eee/order',
                'name'        => 'Order',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'order',
                'name'        => 'Order',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Eee',
                'module'    => 'Order',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'eee.order.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
