<?php


return  
    [
        'model' => [
            'model' => \Order\Eee\Models\Subscription::class,
            'repository' => \Order\Eee\Repositories\Eloquent\SubscriptionRepository::class,
            'table' => 'subscriptions',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'createdat', 'updated_at'],
            'appends' => [],
            'fillable' => ['id',  'company_id',  'seller_company_id',  'user_id',  'seller_id',  'order_id',  'cart_id',  'address_id',  'status',  'delivery_type',  'deleted_at',  'created_at',  'updated_at'],
            'translatables' => [],
            'upload_folder' => 'eee/subscription',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            "company_id" => [
                "key" => "company_id", 
                "type" => "text", 
                "label" => 'eee::subscription.label.company_id', 
                'sort' => true,
                'roles' => [],
            ],
            "seller_company_id" => [
                "key" => "seller_company_id", 
                "type" => "text", 
                "label" => 'eee::subscription.label.seller_company_id', 
                'sort' => true,
                'roles' => [],
            ],
            "seller_id" => [
                "key" => "seller_id", 
                "type" => "text", 
                "label" => 'eee::subscription.label.seller_id', 
                'sort' => true,
                'roles' => [],
            ],
            "order_id" => [
                "key" => "order_id", 
                "type" => "text", 
                "label" => 'eee::subscription.label.order_id', 
                'sort' => true,
                'roles' => [],
            ],
            "cart_id" => [
                "key" => "cart_id", 
                "type" => "text", 
                "label" => 'eee::subscription.label.cart_id', 
                'sort' => true,
                'roles' => [],
            ],
            "address_id" => [
                "key" => "address_id", 
                "type" => "text", 
                "label" => 'eee::subscription.label.address_id', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_type" => [
                "key" => "delivery_type", 
                "type" => "text", 
                "label" => 'eee::subscription.label.delivery_type', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            'company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::subscription.label.company_id',
                "placeholder" => 'eee::subscription.placeholder.company_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'seller_company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::subscription.label.seller_company_id',
                "placeholder" => 'eee::subscription.placeholder.seller_company_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'seller_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::subscription.label.seller_id',
                "placeholder" => 'eee::subscription.placeholder.seller_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'order_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::subscription.label.order_id',
                "placeholder" => 'eee::subscription.placeholder.order_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'cart_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::subscription.label.cart_id',
                "placeholder" => 'eee::subscription.placeholder.cart_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'address_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::subscription.label.address_id',
                "placeholder" => 'eee::subscription.placeholder.address_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_type' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::subscription.label.delivery_type',
                "placeholder" => 'eee::subscription.placeholder.delivery_type',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'eee/subscription/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'eee/subscription/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'eee/subscription',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'eee/subscription',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'eee/subscription',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'eee/subscription',
                'method' => 'DELETE',
            ],
        ],
        'order' => [
            'created_at' => 'eee::subscription.label.created_at',
            'name' => 'eee::subscription.label.name',
            'status' => 'eee::subscription.label.status',
        ],
        'groups' => [
            'main' => 'eee::subscription.groups.main',
            'details' => 'eee::subscription.groups.details',
            'images' => 'eee::subscription.groups.images',
            'settings' => 'eee::subscription.groups.settings',
        ],
        'controller' => [
            'provider' => 'Order',
            'package' => 'Eee',
            'module' => 'Subscription',
        ],
    ];
